<?php
error_reporting(0);

$ip = $_SERVER['REMOTE_ADDR'];
$blacklistFile = 'blacklist.txt';

// Daftar domain/link redirect
$redirectLinks = [
    'https://www.google.com',
    'https://bbc.com',
    'https://cnn.com',
    'https://nytimes.com',
    'https://reuters.com',
    'https://aljazeera.com',
    'https://theguardian.com',
    'https://wsj.com',
    'https://forbes.com',
    'https://bloomberg.com',
    'https://npr.org',
    'https://abcnews.go.com',
    'https://cnbc.com',
    'https://marketwatch.com',
    'https://time.com',
    'https://usatoday.com',
    'https://msnbc.com',
    'https://huffpost.com',
    'https://newsweek.com',
    'https://thehill.com',
    'https://latimes.com',
    'https://news.ycombinator.com',
    'https://vox.com',
    'https://dailybeast.com',
    'https://businessinsider.com',
    'https://investing.com',
    'https://theverge.com',
    'https://buzzfeednews.com',
    'https://example.com',
    'https://openai.com',
    'https://github.com',
    'https://stackoverflow.com',
    'https://reddit.com',
    'https://twitter.com',
    'https://linkedin.com',
    'https://medium.com',
    'https://quora.com',
    'https://producthunt.com',
    'https://techcrunch.com',
    'https://entrepreneur.com',
    'https://mashable.com',
    'https://buzzfeed.com',
    'https://lifehacker.com',
    'https://cnet.com',
    'https://wired.com',
    'https://theatlantic.com',
    'https://fortune.com',
    'https://wsj.com',
    'https://cnbc.com',
    'https://npr.org'
];

function redirectToRandomLink($links) {
    $randomLink = $links[array_rand($links)];
    header("Location: $randomLink");
    exit;
}

$blacklistedIps = file_exists($blacklistFile)
    ? file($blacklistFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)
    : [];
    
    
$whitelist = [
    '127.0.0.1',
    '103.47.134.119',
    '103.14.16.13',
    '203.83.40.58'
];

function isWhitelisted($ip, $whitelist) {
    return in_array($ip, $whitelist);
}


if (isWhitelisted($ip, $whitelist)) {
    return;
}


// Redirect jika IP sudah di-blacklist
if (in_array($ip, $blacklistedIps)) {
    redirectToRandomLink($redirectLinks);
}

// API CHECK
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://netdetective.p.rapidapi.com/query?ipaddress=$ip",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 10,
    CURLOPT_HTTPHEADER => [
        "x-rapidapi-host: netdetective.p.rapidapi.com",
        "x-rapidapi-key: 7662de51f3msh12c8350db6a5323p148f98jsnf8b2683b14f2"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

// Jika CURL error → ABAIKAN
if ($err || !$response) {
    return; // jangan redirect, jangan blacklist
}

$data = json_decode($response, true);

// Jika response tidak valid → ABAIKAN
if (!isset($data['result']) || !is_array($data['result'])) {
    return;
}

$flags = $data['result'];

// Jika field tidak lengkap → ABAIKAN
$requiredKeys = [
    'isVpn','isDataCenter','isBruteForce','isSpam','isBogon',
    'isZombie','isCompromised','isProxyHttp','isProxySocks','isDDos'
];

// Pastikan semua key ada, kalau tidak lengkap → skip
foreach ($requiredKeys as $key) {
    if (!isset($flags[$key])) {
        return;
    }
}

$isSuspicious =
    $flags['isVpn'] ||
    $flags['isDataCenter'] ||
    $flags['isBruteForce'] ||
    $flags['isSpam'] ||
    $flags['isBogon'] ||
    $flags['isZombie'] ||
    $flags['isCompromised'] ||
    $flags['isProxyHttp'] ||
    $flags['isProxySocks'] ||
    $flags['isDDos'];

if ($isSuspicious) {
    if (!in_array($ip, $blacklistedIps)) {
        file_put_contents($blacklistFile, $ip . PHP_EOL, FILE_APPEND);
    }
    redirectToRandomLink($redirectLinks);
}

?>
