<?php

if (isset($_GET['bin'])) {
    // Nomor yang akan dikirim sebagai parameter
    $bin = $_GET['bin'];

    // Membersihkan dan memvalidasi input
    $cardBIN = substr(filter_var($bin, FILTER_SANITIZE_STRING), 0, 6);

    // Menggunakan URL API yang benar
    $url = "https://data.handyapi.com/bin/" . $cardBIN;
    
    // Konfigurasi opsi untuk stream context
    $options = [
        "http" => [
            "method" => "GET",
        ]
    ];
    
    // Membuat stream context
    $context = stream_context_create($options);
    
    // Mengambil data dari API
    $response = @file_get_contents($url, false, $context);

    if ($response !== false) {
        // Mengonversi respons JSON menjadi array
        $data = @json_decode($response, true);

        if ($data !== null) {
            // Menjadikan respon menjadi JSON
            header('Content-Type: application/json');
            echo json_encode($data, JSON_PRETTY_PRINT);
        } else {
            // Menangani jika gagal mengurai JSON
            echo 'Error parsing JSON response.';
        }
    } else {
        // Menangani jika file_get_contents gagal
        echo 'Error fetching data from API.';
    }
} 
else {
    // Menangani jika parameter bin tidak ditemukan dalam request
    echo 'Parameter Bin tidak ditemukan dalam request.';
}
?>