<?php
function _404($message)
{
    echo "
<!DOCTYPE html>
<html>
<head>
    <meta charset=\"utf-8\">
    <meta name=\"robots\" content=\"noindex, nofollow, noarchive, nosnippet, noodp, noydir\">
    <title>404</title>
    <meta http-equiv=\"refresh\" content=\"0;url=" . uriRand() . "\">
</head>
<body>
<code>{$message}</code>
</body>
</html>
    ";
}

function uriRand()
{
    $uri = [
        'https://bbc.com',
        'https://cnn.com',
        'https://nytimes.com',
        'https://reuters.com',
        'https://aljazeera.com',
        'https://theguardian.com',
        'https://wsj.com',
        'https://forbes.com',
        'https://bloomberg.com',
        'https://npr.org',
        'https://abcnews.go.com',
        'https://cnbc.com',
        'https://marketwatch.com',
        'https://time.com',
        'https://usatoday.com',
        'https://msnbc.com',
        'https://huffpost.com',
        'https://newsweek.com',
        'https://thehill.com',
        'https://latimes.com',
        'https://news.ycombinator.com',
        'https://vox.com',
        'https://dailybeast.com',
        'https://businessinsider.com',
        'https://investing.com',
        'https://theverge.com',
        'https://buzzfeednews.com',
        'https://example.com',
        'https://openai.com',
        'https://github.com',
        'https://stackoverflow.com',
        'https://reddit.com',
        'https://twitter.com',
        'https://linkedin.com',
        'https://medium.com',
        'https://quora.com',
        'https://producthunt.com',
        'https://techcrunch.com',
        'https://entrepreneur.com',
        'https://mashable.com',
        'https://buzzfeed.com',
        'https://lifehacker.com',
        'https://cnet.com',
        'https://wired.com',
        'https://theatlantic.com',
        'https://fortune.com',
        'https://wsj.com',
        'https://cnbc.com',
        'https://npr.org'
    ];

    shuffle($uri);
    return $uri[0];
}

function blackbox($ip)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://blackbox.ipinfo.app/lookup/" . $ip);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $resp = curl_exec($ch);
    curl_close($ch);
    return $resp === "Y";
}

function blockIPInHTAccess($ip)
{
    $htaccessPath = __DIR__ . '/.htaccess'; // Path to the .htaccess file
    $blockRule = "Deny from $ip\n";

    // Append the block rule to the .htaccess file
    file_put_contents($htaccessPath, $blockRule, FILE_APPEND | LOCK_EX);
}

function logBotIP($ip)
{
    $logFile = __DIR__ . '/log_bot.txt'; // Path to the log file
    $logMessage = date('Y-m-d H:i:s') . " - Bot detected: $ip\n";

    // Append the log message to log_bot.txt
    file_put_contents($logFile, $logMessage, FILE_APPEND | LOCK_EX);
}

$ipAddress = $_SERVER['REMOTE_ADDR']; // Get the user's IP address

// Check if there is no active session or if the IP is identified as a bot
if (blackbox($ipAddress)) {
    // Block IP in .htaccess
    blockIPInHTAccess($ipAddress);

    // Log the bot detection
    logBotIP($ipAddress);

    // Return 404 and redirect
    _404("Access blocked - Not Found");
    exit;
}
?>